#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <lforms.h>

void ff_stack(ff_window_t win, ff_window_t* child, int children, int width, int height)
{
    int cpw, cph, wpw, wph, cx = 0, cy = 0, pos, pad = 0;
    int cw = width, ch = height, total, maxw = 0, maxh = 0;
    int* pw;
    int* ph;
    const char* orientation = ff_get(win, "stack-orientation");
    const char* align = ff_get(win, "stack-align");
    const char* anchor = ff_get(win, "stack-anchor");
    const char* autosize = ff_get(win, "stack-autosize");
    int spacing = ff_geti(win, "stack-spacing");
    int vert, ancfill, ancval, samewidth = 0, sameheight = 0, fill = 0;
    int contw = ff_geti(win, "container-width");
    int conth = ff_geti(win, "container-height");
    int pa, i;
    if (!children) return;
    vert = !orientation || !strcmp(orientation, "vertical");
    pa = ff_geti(win, "padding-around");
    cx += ff_geti(win, "padding-left") + pa;
    cy += ff_geti(win, "padding-top") + pa;
    cw -= ff_geti(win, "padding-right") + cx + pa;
    ch -= ff_geti(win, "padding-bottom") + cy + pa;

    pw = malloc(sizeof(int)*(size_t)children);
    ph = malloc(sizeof(int)*(size_t)children);

    /* default autosize is preferred */
    if (autosize) {
        if (!strcmp(autosize, "same-width")) samewidth = 1;
        else if (!strcmp(autosize, "same-height")) sameheight = 1;
        else if (!strcmp(autosize, "same-size")) samewidth = sameheight = 1;
    }

    wpw = wph = 0;
    if (vert) {
        for (i=0; i<children; i++) {
            ff_lh_prefsize(child[i], &cpw, &cph, FF_NOFLAGS);
            pw[i] = cpw;
            ph[i] = cph;
            if (maxw < cpw) maxw = cpw;
            if (maxh < cph) maxh = cph;
            wph += cph + (i ? spacing : 0);
        }
        wpw = maxw;
    } else {
        for (i=0; i<children; i++) {
            ff_lh_prefsize(child[i], &cpw, &cph, FF_NOFLAGS);
            pw[i] = cpw;
            ph[i] = cph;
            if (maxw < cpw) maxw = cpw;
            if (maxh < cph) maxh = cph;
            wpw += cpw + (i ? spacing : 0);
        }
        wph = maxh;
    }
    if (samewidth || sameheight) {
        for (i=0; i<children; i++) {
            if (samewidth) pw[i] = maxw;
            if (sameheight) ph[i] = maxh;
        }
        if (vert) {
            wph = 0;
            for (i=0; i<children; i++)
                wph += ph[i] + (i ? spacing : 0);
        } else {
            wpw = 0;
            for (i=0; i<children; i++)
                wpw += pw[i] + (i ? spacing : 0);
        }
    }
    wpw += cx + pa + ff_geti(win, "padding-right");
    wph += cy + pa + ff_geti(win, "padding-bottom");

    if (wpw < contw) wpw = contw;
    if (wph < conth) wph = conth;

    ff_prefsize(win, wpw, wph);

    if (cw < 1 || ch < 1) {
        free(pw);
        free(ph);
        return;
    }

    total = 0;
    for (i=0; i<children; i++) {
        total += (vert ? ph[i] : pw[i]);
        if (i < children - 1) total += spacing;
    }

    if (!align || !strcmp(align, "left") || !strcmp(align, "top"))
        pad = 0;
    else if (!strcmp(align, "center"))
        pad = ((vert ? ch : cw) - total) / 2;
    else if (!strcmp(align, "right") || !strcmp(align, "bottom"))
        pad = (vert ? ch : cw) - total;
    else if (!strcmp(align, "fill")) {
        double spactotl = children > 1 ? (double)((children - 1)*spacing) : 0;
        double scale;
        char* noscale = malloc((size_t)children);
        int noscaletotal = 0;
        for (i=0; i<children; i++) {
            noscale[i] = ff_geti(child[i], "stack-noscale") ? 1 : 0;
            if (noscale[i]) noscaletotal += (vert ? ph[i] : pw[i]);
        }
        scale = (double)((vert ? ch : cw) - spactotl - noscaletotal)/(double)(total - spactotl - noscaletotal);
        pad = 0;
        for (i=0; i<children; i++)
            if (!noscale[i]) {
                if (vert)
                    ph[i] = (int)(ph[i]*scale);
                else
                    pw[i] = (int)(pw[i]*scale);
            }
        free(noscale);
        fill = 1;
    }

    if (!anchor || !strcmp(anchor, "both")) {
        ancval = 0;
        ancfill = 1;
    } else {
        ancfill = 0;
        if (!strcmp(anchor, "center"))
            ancval = 2;
        else if (!strcmp(anchor, "bottom") || !strcmp(anchor, "right"))
            ancval = 3;
        else
            ancval = 1; /* top/left */
    }

    pos = (vert ? cy : cx) + pad;
    for (i=0; i<children; i++) {
        int x = vert ? cx + (ancval <= 1 ? 0 : (ancval == 2 ? (cw - pw[i]) / 2 : cw - pw[i])) : pos;
        int y = vert ? pos : cy + (ancval <= 1 ? 0 : (ancval == 2 ? (ch - ph[i]) / 2 : ch - ph[i]));
        int w = vert ? (ancfill ? cw : pw[i]) : pw[i];
        int h = vert ? ph[i] : (ancfill ? ch : ph[i]);
        if (i == children - 1 && fill) {
            if (vert)
                h = cy + ch - y;
            else
                w = cx + cw - x;
        }
        ff_lh_place(child[i], x, y, w, h);
        pos += (vert ? h : w) + spacing;
    }

    free(ph);
    free(pw);
}

