#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

typedef struct _state_t
{
    int max, progress;
} state_t;

static int set_handler(void* prg, ff_event_t* ev, void* data)
{
    int newval;
    ff_namevalue_t* kv = ev->p;
    if (!strcmp(kv->name, "max")) {
        state_t* state = ff_get(prg, "-state");
        newval = (int)(ff_intptr_t)kv->value;
        if (newval < 0) newval = 0;
        if (newval != state->max) {
            state->max = newval;
            ff_paint(prg);
        }
    } else if (!strcmp(kv->name, "progress")) {
        state_t* state = ff_get(prg, "-state");
        newval = (int)(ff_intptr_t)kv->value;
        if (newval < 0) newval = 0;
        if (newval > state->max) newval = state->max;
        if (newval != state->progress) {
            state->progress = newval;
            ff_paint(prg);
        }
    } else return FF_NO;
    return FF_YES;
}

static int get_handler(void* prg, ff_event_t* ev, void* data)
{
    ff_namevalue_t* kv = ev->p;
    if (!strcmp(kv->name, "max")) {
        state_t* state = ff_get(prg, "-state");
        kv->value = (void*)(ff_intptr_t)state->max;
    } else if (!strcmp(kv->name, "progress")) {
        state_t* state = ff_get(prg, "-state");
        kv->value = (void*)(ff_intptr_t)state->progress;
    } else return FF_NO;
    return FF_YES;
}

static void paint_marks(ff_gc_t gc, int x1, int x2, int h, int l)
{
    int xh = x1 + (x2 - x1)/2;
    if (l > h - 3) l = h - 3;
    ff_color(gc, FF_3DSHADOW_COLOR);
    ff_line(gc, xh, l, xh, h - 3);
    if (x2 - x1 > 20) {
        paint_marks(gc, x1, xh, h, l + 1);
        paint_marks(gc, xh, x2, h, l + 1);
    }
}

static int paint_handler(void* prg, ff_event_t* ev, void* data)
{
    ff_gc_t gc = ev->p;
    state_t* state = ff_get(prg, "-state");
    int w, h, pp;
    ff_area(prg, NULL, NULL, &w, &h);

    pp = state->max > 0 ? state->progress*(w - 5)/state->max : 0;

    if (pp > 0 && pp < w - 5) {
        ff_color_attr(gc, prg, "background", FF_3DFACE_COLOR);
        ff_fill(gc, pp + 3, 2, w - 3, h - 3);
        paint_marks(gc, 2, w - 3, h, h/2);
        ff_color(gc, FF_3DSHADOW_COLOR);
        ff_fill(gc, 2, 2, pp + 2, h - 3);
        ff_color(gc, FF_3DDARK_COLOR);
        ff_line(gc, pp + 2, 2, pp + 2, h - 3);
    } else if (pp == 0) {
        ff_color_attr(gc, prg, "background", FF_3DFACE_COLOR);
        ff_fill(gc, 2, 2, w - 3, h - 3);
        paint_marks(gc, 2, w - 3, h, h/2);
    } else {
        ff_color(gc, FF_3DSHADOW_COLOR);
        ff_fill(gc, 2, 2, w - 3, h - 3);
    }

    ff_color(gc, FF_3DSHADOW_COLOR);
    ff_line(gc, 0, 0, w - 1, 0);
    ff_line(gc, 0, 0, 0, h - 1);
    ff_color(gc, FF_3DDARK_COLOR);
    ff_line(gc, 1, 1, w - 2, 1);
    ff_line(gc, 1, 1, 1, h - 2);
    ff_color(gc, FF_3DLIGHT_COLOR);
    ff_line(gc, 0, h - 1, w - 1, h - 1);
    ff_line(gc, w - 1, 0, w - 1, h - 1);
    ff_color(gc, FF_3DFACE_COLOR);
    ff_line(gc, 1, h - 2, w - 2, h - 2);
    ff_line(gc, w - 2, 1, w - 2, h - 2);
    ff_color(gc, FF_3DSHADOW_COLOR);
    ff_pixel(gc, 1, h - 2);
    ff_pixel(gc, w - 2, 1);

    return FF_YES;
}

static int destroy_handler(void* prg, ff_event_t* ev, void* data)
{
    free(ff_get(prg, "-state"));
    return FF_NO;
}

ff_window_t ff_progress(ff_window_t parent, int max, int progress)
{
    ff_window_t prg = ff_window(parent, 0, 0, 100, 16, FF_NOFLAGS);
    state_t* state = calloc(1, sizeof(state_t));
    if (max < 0) max = 0;
    if (progress < 0) progress = 0;
    if (progress > max) progress = max;
    state->max = max;
    state->progress = progress;
    ff_set(prg, "-state", state);
    ff_setcs(prg, "class", "progress");
    ff_link(prg, FF_SET, set_handler, NULL);
    ff_link(prg, FF_GET, get_handler, NULL);
    ff_link(prg, FF_PAINT, paint_handler, NULL);
    ff_link(prg, FF_DESTROY, destroy_handler, NULL);
    ff_prefsize(prg, 100, 16);
    return prg;
}
