#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

typedef struct _state_t
{
    ff_bitmap_t bitmap;
} state_t;


static void update_prefsize(ff_window_t img)
{
    state_t* state = ff_get(img, "-state");
    int bw, bh;
    ff_bitmap_size(state->bitmap, &bw, &bh);
    ff_prefsize(img, bw ? bw : 1, bh ? bh : 1);
}

static int set_handler(void* img, ff_event_t* ev, void* data)
{
    ff_namevalue_t* nv = ev->p;
    state_t* state = ff_get(img, "-state");
    if (!strcmp(nv->name, "bitmap")) {
        ff_incref(FF_REFOBJ(nv->value));
        ff_decref(FF_REFOBJ(state->bitmap));
        state->bitmap = nv->value;
        update_prefsize(img);
        ff_paint(img);
        return 1;
    }
    return 0;
}

static int get_handler(void* img, ff_event_t* ev, void* data)
{
    ff_namevalue_t* nv = ev->p;
    state_t* state = ff_get(img, "-state");
    if (!strcmp(nv->name, "bitmap")) {
        nv->value = state->bitmap;
        return 1;
    }
    return 0;
}

static int destroy_handler(void* img, ff_event_t* ev, void* data)
{
    state_t* state = ff_get(img, "-state");
    ff_decref(FF_REFOBJ(state->bitmap));
    free(state);
    return 0;
}

static int paint_handler(void* img, ff_event_t* ev, void* data)
{
    ff_gc_t gc = ev->p;
    int x, y, w, h, bw, bh;
    state_t* state = ff_get(img, "-state");
    ff_area(img, NULL, NULL, &w, &h);
    ff_color_attr(gc, img, "background", FF_3DFACE_COLOR);
    ff_fill(gc, 0, 0, w, h);
    if (state->bitmap) {
        ff_bitmap_size(state->bitmap, &bw, &bh);
        x = (w - bw)/2;
        y = (h - bh)/2;
        ff_fill(gc, 0, 0, w, y);
        ff_fill(gc, 0, y, x, y + bh);
        ff_fill(gc, x + bw, y, w, y + bh);
        ff_fill(gc, 0, y + bh, w, h);
        ff_draw(gc, x, y, state->bitmap);
    }

    return 1;
}

ff_window_t ff_image(ff_window_t parent, ff_bitmap_t bitmap)
{
    ff_window_t img = ff_window(parent, 0, 0, 1, 1, FF_NOFLAGS);
    ff_set(img, "-state", calloc(1, sizeof(state_t)));
    ff_set(img, "class", (void*)"image");
    ff_link(img, FF_SET, set_handler, NULL);
    ff_link(img, FF_GET, get_handler, NULL);
    ff_set(img, "bitmap", bitmap);
    ff_link(img, FF_PAINT, paint_handler, NULL);
    ff_link(img, FF_DESTROY, destroy_handler, NULL);
    return img;
}

