/* XPM */

/* This source file acts as both the source code for the example *and*
 * an XPM image file that ff_xpmload can load (not all XPM loaders can
 * load this though, for example Gimp can but ImageMagick cannot, so
 * do not use this in real code... it is only a hack to avoid creating
 * a separate XPM file with the same data :-) */

static char* smiley_xpm[] = {
"16 16 5 1",
"  c None",
". c #000000",
"+ c #F0C000",
"@ c #FFFFFF",
"# s dark-background",      /* This is used to make the shadow */
"                ",
"      ....      ",
"    ..++++..    ",
"   .++++++++.   ",
"  .+...++...+.  ",
"  .+@..++..@+.# ",
" .++@..++..@++. ",
" .+++++..+++++.#",
" .+++++..+++++.#",
" .++.++++++.++.#",
"  .++......++.##",
"  .+++....+++.# ",
"   .++++++++.## ",
"    ..++++..##  ",
"     #....###   ",
"       ####     "};

#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */

/* Entry point */
int main(int argc, char** argv)
{
    char* xpmfile;

    /* Initialize */
    if (!ff_init(argc, argv, "XPM Image"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("XPM Image", NULL,
                              200, 100,
                              FF_NOFLAGS);

    /* Setup layout */
    ff_layout(main_frame, ff_stack);
    ff_setcs(main_frame, "stack-align", "center");
    ff_seti(main_frame, "padding-around", 10);
    ff_seti(main_frame, "stack-spacing", 5);

    /* Create the image widget with the XPM data */
    ff_label(main_frame, "Embedded image created with ff_xpm:");
    ff_image(main_frame, ff_xpm(smiley_xpm, NULL, NULL));

    /* Create the image using the code of this example as an XPM file */
    xpmfile = malloc(strlen(argv[0]) + 3);
    strcpy(xpmfile, argv[0]);
    if (strstr(xpmfile, ".exe")) strstr(xpmfile, ".exe")[0] = 0;
    strcat(xpmfile, ".c");
    ff_label(main_frame, "XPM image loaded with ff_xpmload:");
    ff_image(main_frame, ff_xpmload(xpmfile, NULL, NULL));
    free(xpmfile);

    /* Pack the window */
    ff_pack(main_frame, FF_BOTH);

    /* Enter main loop */
    return ff_run();
}
