#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t tabstrip;    /* The tab strip widget */
static ff_window_t label;       /* A label to show the selected tab */

/* Event callback for the FF_SELECT event that tabstrip fires when the
 * selected tab has changed: we'll just set the label to a caption that
 * reflects this */
static int selected(void* ts, ff_event_t* ev, void* data)
{
    char tmp[256];
    sprintf(tmp, "Selected tab is #%i, '%s'", ev->x, (char*)ff_get(ts, "text"));
    ff_set(label, "caption", tmp);
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Some captions */
    const char* tabcaptions[] = {
        "Properties",
        "Objects",
        "Settings",
        "Help"};

    /* Initialize */
    if (!ff_init(argc, argv, "Tabstrip"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Tabstrip Test", NULL,
                              16, 16,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_border);

    /* Create widgets */
    tabstrip = ff_tabstrip(main_frame, tabcaptions, 4, 1);
    ff_set(tabstrip, "border-align", "top");
    ff_link(tabstrip, FF_SELECT, selected, NULL);
    label = ff_label(main_frame, "Selected tab is #X, 'XXXXXXXXXX'");
    ff_set(label, "border-align", "center");
    ff_seti(label, "margin-around", 40);

    /* Pack the window both horizontally and vertically to fit
     * the preferred size of its chilren. */
    ff_pack(main_frame, FF_BOTH);

    /* Enter main loop */
    return ff_run();
}

