#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t notebook;    /* The notebook */

/* Called when any of the "Go to page" buttons is clicked */
static int nextpage(void* btn, ff_event_t* ev, void* data)
{
    ff_seti(notebook, "selection", (ff_geti(notebook, "selection") + 1)%5);
    return FF_YES;
}

/* Entry point */
int main(int argc, char** argv)
{
    ff_window_t ts;     /* A tabstrip to use with the notebook */
    ff_window_t btn;    /* Helper variable to hold some buttons */
    const char* tab[] = {"Page #0", "Page #1", "Page #2", "Page #3", "Page #4"};
    int i;

    /* Initialize */
    if (!ff_init(argc, argv, "Notebook"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Notebook Test", NULL,
                              320, 160,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_border);

    /* Create the tabstrip that will show the pages */
    ts = ff_tabstrip(main_frame, tab, 5, 0);
    ff_set(ts, "border-align", "top");

    /* Create the notebook */
    notebook = ff_notebook(main_frame, ts);
    ff_set(notebook, "border-align", "center");

    /* Create 5 pages of content */
    for (i=0; i < 5; i++) {
        char tmp[64];

        /* Set the selected page in the notebook so that the buttons
         * will be created with the correct visibility from the
         * start. */
        ff_seti(notebook, "selection", i);

        /* Create the button */
        sprintf(tmp, "Button in page #%i", i);
        btn = ff_button(notebook, tmp, NULL, NULL);
        ff_place(btn, 10 + i*10, 10 + i*10, 200, 25);
        sprintf(tmp, "Go to page #%i", (i+1)%5);
        btn = ff_button(notebook, tmp, nextpage, NULL);
        ff_place(btn, 10 + i*10, 40 + i*10, 200, 25);
    }

    /* Create a button that will be visible in all pages */
    btn = ff_button(notebook, "Omnipresent Button", NULL, NULL);
    ff_place(btn, 200, 10, 50, 50);
    ff_seti(btn, "notebook-page", -1);

    /* Select the second page */
    ff_seti(notebook, "selection", 1);

    /* Pack the notebook in both dimensions to have all buttons
     * shrink to their preferred sizes. */
    ff_pack(notebook, FF_BOTH);

    /* Pack the window horizontally only */
    ff_pack(main_frame, FF_HORIZONTAL);

    /* Enter main loop */
    return ff_run();
}
