#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */

/* Entry point */
int main(int argc, char** argv)
{
    ff_window_t lb;
    int i;

    /* Initialize */
    if (!ff_init(argc, argv, "List Test"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("List Test", NULL,
                              320, 320,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_border);
    ff_seti(main_frame, "padding-around", 10);

    /* Create the list */
    lb = ff_list(main_frame, NULL, NULL, 0, 0);
    ff_set(lb, "border-align", "center");

    /* Freeze the list to avoid redraws while adding items */
    ff_freeze(lb);

    /* Add 1000 random items */
    for (i=0; i < 1000; i++) {
        char tmp[100];
        sprintf(tmp, "Item number %i rand %i", i, rand());
        ff_list_add(lb, tmp, 0);
    }

    /* Thaw the list, will cause a repaint */
    ff_thaw(lb);

    /* Select the second item in the list */
    ff_list_select(lb, 1, 0);

    /* Enter main loop */
    return ff_run();
}

