#include <lforms.h>

/* We can include the XPM image directly */
#include "../icons/gear.xpm"

static ff_window_t main_frame;  /* The main frame (window) */

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Image"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Image", NULL,
                              100, 48,
                              FF_NOFLAGS);

    /* Setup layout */
    ff_layout(main_frame, ff_border);

    /* Create the image widget with a bitmap created using ff_xpm */
    ff_image(main_frame, ff_xpm(gear_xpm, NULL, NULL));

    /* Enter main loop */
    return ff_run();
}

