#include <time.h>
#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t time_field;  /* Field with the current time */

/* Updates the time field with the current time */
static void update_time(void)
{
    char* str;
    time_t now;

    /* Get current time */
    time(&now);
    str = ff_strdup(ctime(&now));

    /* Remove trailing newlines */
    while (str[strlen(str) - 1] == '\n' || str[strlen(str) - 1] == '\r')
        str[strlen(str) - 1] = '\0';

    /* Set the caption attribute of the time field to the trimmed string */
    ff_set(time_field, "caption", str);

    /* Release the string */
    ff_free(str);
}

/* Called to handle the timer event */
static int timer_handler(void* win, ff_event_t* event, void* data)
{
    /* Just update the current time */
    update_time();

    /* Notify Little Forms that we handled the event */
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Hello"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Little Forms Clock", NULL,
                              300, 120,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 25);

    /* Add the widgets */
    time_field = ff_label(main_frame, "");
    ff_seti(time_field, "preferred-width", 200);
    ff_set(time_field, "halign", "center");

    /* Update the time now */
    update_time();

    /* Setup a timer to update the time every second (note that since timers
     * are not 100% accurate, this might skip a second now and then) */
    ff_timer(main_frame, 1000);
    ff_link(main_frame, FF_TIMER, timer_handler, NULL);

    /* Pack the window both horizontally and vertically to fit
     * the preferred size of its chilren */
    ff_pack(main_frame, FF_BOTH);

    /* Enter main loop */
    return ff_run();
}
