VERSION 4.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Enemy Fighter"
   ClientHeight    =   2910
   ClientLeft      =   2670
   ClientTop       =   2730
   ClientWidth     =   2925
   Height          =   3315
   Icon            =   "Form1.frx":0000
   KeyPreview      =   -1  'True
   Left            =   2610
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2910
   ScaleWidth      =   2925
   Top             =   2385
   Width           =   3045
   Begin VB.PictureBox Picture1 
      Height          =   2460
      Left            =   240
      ScaleHeight     =   2400
      ScaleWidth      =   2400
      TabIndex        =   0
      Top             =   120
      Width           =   2460
   End
   Begin VB.Label lblStatus 
      AutoSize        =   -1  'True
      Caption         =   "Whatever"
      Height          =   195
      Left            =   240
      TabIndex        =   1
      Top             =   2640
      Width           =   705
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Private Type Cell
  ID As Byte
  Revealed As Byte
End Type

Private Type Map
  Cell(15, 15) As Cell
End Type
  
Dim Map As Map
Dim PX As Integer, PY As Integer
Dim EnemyCount As Integer

Private Sub Command1_Click()
  InitMap
  DrawMap
End Sub



Public Sub InitMap()
  For Y% = 0 To 15
    For X% = 0 To 15
      With Map.Cell(X%, Y%)
        .ID = Int(Rnd * 2)
        .Revealed = False
      End With
    Next
  Next
  For I% = 0 To 16
    Map.Cell(Int(Rnd * 16), Int(Rnd * 15) + 1).ID = 2
    Map.Cell(Int(Rnd * 16), Int(Rnd * 16)).ID = 3
  Next I%
  Map.Cell(Int(Rnd * 16), 0).ID = 4
  EnemyCount = 0
  For Y% = 0 To 15
    For X% = 0 To 15
      With Map.Cell(X%, Y%)
        If .ID = 2 Then EnemyCount = EnemyCount + 1
      End With
    Next
  Next
  PX = Int(Rnd * 14) + 1
  PY = Int(Rnd * 14)
  Map.Cell(PX, PY + 1).ID = 0
  Gold = 0
  NewHero
  CheckStatus
  GoToCell PX, PY + 1
End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  Select Case KeyCode
    Case 39: GoToCell PX + 1, PY
    Case 37: GoToCell PX - 1, PY
    Case 38: GoToCell PX, PY - 1
    Case 40: GoToCell PX, PY + 1
  End Select
End Sub

Private Sub Form_Load()
  Left = (Screen.Width - Width) \ 2
  Top = (Screen.Height - Height) \ 2
  InitMap
End Sub



Public Function ColorForID(ByVal ID As Integer)
  Select Case ID
    Case 0: ColorForID = QBColor(6)
    Case 1: ColorForID = QBColor(2)
    Case 2: ColorForID = QBColor(4)
    Case 3: ColorForID = QBColor(14)
    Case 4: ColorForID = QBColor(9)
  End Select
End Function

Public Sub DrawMap()
  TX% = Screen.TwipsPerPixelX * 10
  TY% = Screen.TwipsPerPixelY * 10
  For Y% = 0 To 15
    For X% = 0 To 15
      With Map.Cell(X%, Y%)
        If .Revealed Then
          Picture1.Line (X% * TX%, Y% * TY%)-(X% * TX% + TX%, Y% * TY% + TY%), ColorForID(.ID), BF
        Else
          Picture1.Line (X% * TX%, Y% * TY%)-(X% * TX% + TX%, Y% * TY% + TY%), QBColor(8), BF
        End If
      End With
    Next
  Next
  Picture1.FillColor = QBColor(14)
  Picture1.FillStyle = 0
  Picture1.Circle (PX% * TX% + TX% \ 2, PY% * TX% + TY% \ 2), TX% / 2.5, QBColor(14)
  Picture1.FillStyle = 1
  Picture1.Circle (PX% * TX% + TX% \ 2, PY% * TX% + TY% \ 2), TX% / 2.5, 0
End Sub

Private Sub Form_Unload(Cancel As Integer)
  Unload frmEncounter
End Sub

Private Sub Picture1_Paint()
  DrawMap
End Sub



Public Sub GoToCell(ByVal X As Integer, ByVal Y As Integer)
  If (X < 0) Or (Y < 0) Or (X > 15) Or (Y > 15) Then Exit Sub
  If (X = PX) And (Y = PY) Then Exit Sub
  PX = X
  PY = Y
  Map.Cell(PX, PY).Revealed = True
  DrawMap
  Select Case Map.Cell(PX, PY).ID
    Case 2:
      EnterEncounter
    Case 3:
      MsgBox "Got Gold!"
      Gold = Gold + 1
      Map.Cell(PX, PY).ID = 0
      DrawMap
    Case 4:
      MsgBox "A shop!"
      frmShop.Left = (Screen.Width - frmShop.Width) \ 2
      frmShop.Top = (Screen.Height - frmShop.Height) \ 2
      frmShop.Show 1
  End Select
End Sub

Public Sub EnterEncounter()
  MsgBox "Encounter!"
  frmEncounter.Left = (Screen.Width - frmEncounter.Width) \ 2
  frmEncounter.Top = (Screen.Height - frmEncounter.Height) \ 2
  frmEncounter.Prepare
  frmEncounter.Show 1
  Select Case frmEncounter.GetStatus
    Case 0:
      'whatever
    Case 1:
      MsgBox "That was it. Let's play again"
      InitMap
      DrawMap
    Case 2:
      MsgBox "You are victorious"
      If Int(Rnd * 100) < 40 Then
        MsgBox "...and you found a piece of gold!"
        Gold = Gold + 1
      End If
      Map.Cell(PX, PY).ID = 0
      EnemyCount = EnemyCount - 1
      DrawMap
    Case 3:
      'more whatever
  End Select
  CheckStatus
End Sub

Public Sub CheckStatus()
  lblStatus.Caption = "Enemies:" + Str$(EnemyCount)
  If EnemyCount = 0 Then
    MsgBox "You managed to get rid of all enemies."
    MsgBox "Congratulations. Now let's play again!"
    InitMap
    DrawMap
  End If
End Sub
